/*********************************************/
/* Example Program for ET-ADuC847 STAMP V1.0 */
/* MCU      : ADuC847(XTAL = 32.768 KHz)     */
/*          : Frequency Bus = 12.582912 MHz  */
/* Compiler : Keil C51 (V7.50)               */
/* Function : Demo I2C Interface PCF8574A    */
/* Write By : ETT CO.,LTD.(May/2011)         */
/*********************************************/
//Test By ET-MINI PCF8574A + ET-MINI SEG-A
//PCF8574  Slave ID = 0x40
//PCF8574A Slave ID = 0x70

/* include  section */
#include <aduc847.h>									// ADuC847 SFR : File
#include <stdio.h>                						// Prototype declarations for I/O functions

/* User Define Function */
void write_PCF8574(unsigned char ,unsigned char);		// Write Output PCF8574A
void  I2C_Delay(void);				   					// Delay Clock
void delay(unsigned long);								// Delay Time Function(1..4294967295)

/*--------------------------------------------
The main C function.  Program execution Here 
---------------------------------------------*/
void main (void) 
{  	  
  const char seg_code[16]={0x3F,0x06,0x5b,0x4F,	 		// 7-Segment Code 0..9,A..F
  						   0x66,0x6D,0x7D,0x07,
						   0x7F,0x6F,0x77,0x7c,
						   0x39,0x5e,0x79,0x71};	
						  
  int  seg_ptr;											// 7-Segment Pointer Display
  unsigned char data_out;			 					// Write SPI Buffer
   
  PLLCON = 0x00;										// Initial Clock = 12.582912MHz

  // Initial I2C Interface to PCF8574A  
  MDE = 1;												// MDE = 1  => SDA(MDO),SCL(MCO) Pin = Output
  MCO = 1;												// SCL = 1
  MDO = 1;  											// SDA = 1
  I2CM =1;												// I2CM = 1 => Master Mode

  while(1)												// Loop Continue
  { 
	for(seg_ptr=0;seg_ptr<=15;seg_ptr++)				// 0..9,A..F
	{
	  data_out=seg_code[seg_ptr];						// Get Segment Code	  
	  write_PCF8574(0x70,~data_out);					// Send I2C = PCF8574A+Write(0111+000+W),LED(Toggle Logic Drive)		  
      delay (50000);	  								// Delay Display Output
    }    
  }  
}

/*********************************/
/* Write Output Data to PCF8574A */
/* Addr = ID Code+Direction(W:0) */
/* Data = Output Data Write Port */
/*********************************/
void write_PCF8574(unsigned char Addr,unsigned char Data)	
{
  int I2CBit = 0;										// Bit Counter

  //Start of Generate Start
  MDE = 1;	    										// SDA = Output 
  MDO = 0; 												// SDA = 0
  I2C_Delay();
  MCO = 0; 												// SCL = 0 (Start Bit)
  //End of Generate Start
    
  //Start of Send Slave Address
  for (I2CBit = 0; I2CBit<8; I2CBit++)					// 8 Bit Write
  {
    MDO = (bit)((Addr & 0x80) >> 7);					// MSB First
	MCO = 1;
	I2C_Delay();
	MCO = 0;  											// Strobe Bit Data
	Addr <<= 1;	 										// Next Bit Data
  }
  //ACK Bit
  MDE = 0;												// SDA = Inpit(Read ACK)
  MCO = 1;												// SCL = 1
  I2C_Delay();
  //Get & Verify ACK Here  
  MCO = 0;												// SCL = 0
  MDE = 1;												// SDA = Output
  //End of Send Slave Address

  //Start of Send Data
  for (I2CBit = 0; I2CBit<8; I2CBit++)					// 8 Bit Write
  {
    MDO = (bit)((Data & 0x80) >> 7);					// MSB First
	MCO = 1;

	I2C_Delay();
	MCO = 0;  											// Strobe Bit Data
	Data <<= 1;	 										// Next Bit Data
  }
  //ACK Bit
  MDE = 0;												// SDA = Inpit(Read ACK)
  MCO = 1;												// SCL = 1
  I2C_Delay();
  //Get & Verify ACK Here  
  MCO = 0;												// SCL = 0
  MDE = 1;												// SDA = Output
  //End of Send Data

  //Generate Stop Bit
  MDE = 1;	    										// SDA = Output 
  MDO = 0;  											// SDA = 0
  MCO = 1;  											// SCL = 1 
  I2C_Delay();
  MDO = 1;  											// SDA = 1 (Stop Bit)
}

/**************************/
/* Delay I2C Clock Signal */
/**************************/
void I2C_Delay(void)
{
  int x=50;  											// Short Delay Counter
  while(x > 0) {x--;}
}

/*******************************************/
/* Long Delay Time Function(1..4294967295) */
/*******************************************/
void delay(unsigned long i)
{
  while(i > 0) {i--;}									// Loop Decrease Counter	
  return;
}
